<?php

namespace Snapfile\Entities\Shared;

use Illuminate\Database\Eloquent\Model;

class FileRequest extends Model 
{

    protected $table = 'file_requests';
    public $timestamps = true;
    protected $fillable = array('lead_id', 'active_service_id', 'description', 'completed');
    protected $visible = array('lead_id', 'active_service_id', 'description', 'completed');

    public function fileShares()
    {
        return $this->hasMany('Snapfile\Entities\FileShare', 'file_request_id');
    }

    public function lead()
    {
        return $this->belongsTo('Snapfile\Entities\Shared\Lead', 'lead_id');
    }

    public function activeService()
    {
        return $this->belongsTo('Snapfile\Entities\Shared\ActiveService', 'active_service_id');
    }

}